// -*- c++ -*-

//////////////////////////////////////////////////
// (c) MMIII Sven Reichard
// 

# ifndef XBoardInterfaceTest_h
# define XBoardInterfaceTest_h

# include <cppunit/extensions/HelperMacros.h>

class XBoardInterfaceTest
  : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( XBoardInterfaceTest );
  CPPUNIT_TEST( testFeature );
  CPPUNIT_TEST( testFeatureSet );
  CPPUNIT_TEST( testFeatureRequest );
  CPPUNIT_TEST( testAcceptCommand );
  CPPUNIT_TEST( testUnknownCommand );
  CPPUNIT_TEST( testPingCommand );
  CPPUNIT_TEST( testProtocolVersion );
  CPPUNIT_TEST( testPondering );
  CPPUNIT_TEST( testNoOps );
  CPPUNIT_TEST( testMode );
  CPPUNIT_TEST( testComputer );
  CPPUNIT_TEST( testNew );
  CPPUNIT_TEST( testTimes );
  CPPUNIT_TEST( testQuit );
  CPPUNIT_TEST( testLevel );
  CPPUNIT_TEST( testReject );
  CPPUNIT_TEST( testReadMove );
  CPPUNIT_TEST( testWriteMove );
  CPPUNIT_TEST( testUserName );
  //CPPUNIT_TEST( testResult );
  CPPUNIT_TEST( testSetDepth );
  CPPUNIT_TEST( testSetTime );
  CPPUNIT_TEST( testRating );
  CPPUNIT_TEST( testIcs );
  CPPUNIT_TEST( testUndo );
  CPPUNIT_TEST( testRemove );
  CPPUNIT_TEST( testStalemate );
  CPPUNIT_TEST( testMate );
  CPPUNIT_TEST( testNoMate );
  CPPUNIT_TEST_SUITE_END();
protected:
  void testFeature();
  void testFeatureSet();
  void testFeatureRequest();
  void testAcceptCommand();
  void testUnknownCommand();
  void testPingCommand();
  void testProtocolVersion();
  void testPondering();
  void testNoOps();
  void testMode();
  void testComputer();
  void testNew();
  void testTimes();
  void testQuit();
  void testLevel();
  void testReject();
  void testReadMove();
  void testWriteMove();
  void testUserName();
  void testResult();
  void testSetDepth();
  void testSetTime();
  void testRating();
  void testIcs();
  void testUndo();
  void testRemove();
  void testStalemate();
  void testMate();
  void testNoMate();
};
# endif // XBoardInterfaceTest_h
