# include "TestTestPosition.h"
# include <string>
# include <TestData/TestPosition.h>
# include <Game/Game.h>
# include <Algorithms/HistoryAlphaBeta.h>
# include <Moves/CapturingMove.h>
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( TestTestPosition );

void
TestTestPosition::construction()
{
  std::string forsythe("r6k/8/8/8/8/8/8/R6K/w");
  std::string move("Ra1xa8+");
  std::string title("test position");

  TestPosition position(forsythe, move, title);
  CPPUNIT_ASSERT(forsythe== position.forsythe());
  CPPUNIT_ASSERT(move== position.bestMove());
  CPPUNIT_ASSERT(title== position.title());
};

void
TestTestPosition::search()
{
  Game g;
  HistoryAlphaBeta algo(g);
  std::string forsythe("r6k/8/8/8/8/8/8/R6K/w");
  std::string move("Ra1xa8");
  std::string title("test position");

  TestPosition position(forsythe, move, title);
  CPPUNIT_ASSERT_EQUAL(std::string(""), position.principalVariation());
  bool result = position.search(3, algo);
  CPPUNIT_ASSERT(result);
  //cout<<'\"'<<position.principalVariation()<<'\"'<<endl;
  //CPPUNIT_ASSERT_EQUAL(std::string("1. Rxa8+ Kh7 2. Ra7+ Kh8 \n"), 
  //		       position.principalVariation());
  Square a1(0,0);
  Square a8(0,7);
  CapturingMove solution(a1, a8);
  CPPUNIT_ASSERT(solution == position.solution());
};

void
TestTestPosition::testReadEPD()
{
  std::string 
    s("r3k2r/8/8/8/8/8/8/R3K2R w KQkq - id \"test position\"; abc x;\n"
      "4k3/8/8/8/8/8/8/R3K2R w KQkq -\n");
  std::istringstream input(s);
  TestPosition position;
  position.readEPD(input);
  CPPUNIT_ASSERT_EQUAL(std::string("r3k2r/8/8/8/8/8/8/R3K2R"),
		       position.forsythe());
  CPPUNIT_ASSERT_EQUAL(std::string("w"), position.getColorToMove());
  CPPUNIT_ASSERT_EQUAL(std::string("KQkq"), position.getCastlingRights());
  CPPUNIT_ASSERT_EQUAL( std::string( "-" ), position.getEnPassantSquare() );
  CPPUNIT_ASSERT_EQUAL( std::string("\"test position\""),
			position.getOperand("id"));
  CPPUNIT_ASSERT_EQUAL( std::string("x"), position.getOperand("abc"));
  position.readEPD(input);
  CPPUNIT_ASSERT_EQUAL(std::string("4k3/8/8/8/8/8/8/R3K2R"),
		       position.forsythe());
};

void
TestTestPosition::testWriteEPD()
{
  std::string 
    s("r3k2r/8/8/8/8/8/8/R3K2R w KQkq - abc x; id \"test position\";\n");
  std::istringstream input(s);
  TestPosition position;
  position.readEPD( input );
  std::ostringstream output;
  position.writeEPD( output );

  CPPUNIT_ASSERT_EQUAL( s, output.str() );
};

void
TestTestPosition::testFromGame()
{

  Game g;
  TestPosition position( g );
  std::ostringstream output;
  position.writeEPD( output );
  std::string expected =  "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq -\n";
  CPPUNIT_ASSERT_EQUAL( expected, output.str());
};

void
TestTestPosition::testGetOperand()
{
  std::string 
    s("r3k2r/8/8/8/8/8/8/R3K2R w KQkq - abc x; id \"test position\";\n");
  std::istringstream input(s);
  TestPosition position;
  position.readEPD( input );
  
  CPPUNIT_ASSERT_EQUAL( std::string("x"), position.getOperand("abc"));
};

void
TestTestPosition::testSetOperand()
{
  TestPosition position;
  position.setOperand( "abc", "x");
  CPPUNIT_ASSERT_EQUAL( std::string("x"), position.getOperand("abc"));
};
