
# include "QueenTestCase.h"
# include "PawnTestCase.h"
# include "GameTestCase.h"
# include "DirectionTestCase.h"
# include "CheckSentryTestCase.h"
# include "EvaluationTestCase.h"
# include "AlphaBetaTestCase.h"

# include "TranspositionTableTestCase.h"
# include "TableEntryTestCase.h"
# include "TestPositionalEvaluation.h"
# include "TestRepetitionSentry.h"

# include <cppunit/TextTestResult.h>
# include "TestPositionSuiteTestCase.h"
# include "EnPassantTestCase.h"
# include "CastlingTestCase.h"
# include "TestSmartPointer.h"
# include "TestSanNotation.h"
# include <QuiescenceSearchTestCase.h>
# include <cppunit/extensions/TestFactoryRegistry.h>
# include <TestSanNotation.h>
int testSuite(void)
{
  TextTestResult result;
  TestSuite* suite = new TestSuite("TestSuite");
  

  suite->addTest(CppUnit::TestFactoryRegistry::getRegistry().makeTest());
  
  suite->addTest(EvaluationTestCase::suite());
  suite->addTest(GameTestCase::suite());
  suite->addTest(QueenTestCase::suite());
  suite->addTest(PawnTestCase::suite());
  
  suite->addTest(DirectionTestCase::suite());
  suite->addTest(CheckSentryTestCase::suite());
  suite->addTest(AlphaBetaTestCase::suite());
  suite->addTest(TableEntryTestCase::suite());
  suite->addTest(TranspositionTableTestCase::suite());

  suite->addTest(TestPositionSuiteTestCase::suite());
  suite->addTest(CastlingTestCase::suite());
  suite->addTest(TestSmartPointer::suite());
  suite->addTest(TestSanNotation::suite());
  suite->addTest(TestRepetitionSentry::suite());

  suite-> run(&result);
  std::cout<<result;
  return result.testFailuresTotal();
};

int main(void)
{
  //benchmark();
  return testSuite();
  
};
