/***************************************************************************
                          TestSmartPointer.cpp  -  description
                             -------------------
    begin                : Tue Sep 25 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "TestSmartPointer.h"
# include "TestHeader.h"
# include "Moves/SimpleMove.h"
# include <SmartPointer.h>
using namespace Alice;
TestSmartPointer::TestSmartPointer(const std::string name):
	TestCase(name)
{
};
TestSmartPointer::~TestSmartPointer(){
};
Test*
TestSmartPointer::suite()
{
  TestSuite* testSuite = new TestSuite("TestSmartPointer");
  //AddTest(testSuite, TestSmartPointer, test1);
  AddTest(testSuite, TestSmartPointer, test3);
  AddTest(testSuite, TestSmartPointer, test4);
  AddTest(testSuite, TestSmartPointer, test5);
  return testSuite;
};

void
TestSmartPointer::test3()
{
  int before = Move::getInstances();
  Square a1(0,0);
  Square a2(0,1);
  {
    SmartPointer<Move> move = SimpleMove::createInstance(a1, a2);
    //assertLongsEqual(before+1, Move::getInstances());
    
  }
  CPPUNIT_ASSERT_EQUAL(before, Move::getInstances());
};

void
TestSmartPointer::test4()
{
  int before = Move::getInstances();
  Square a1(0,0);
  Square a2(0,1);
  {
    SmartPointer<Move> move = SimpleMove::createInstance(a1, a2);
    SmartPointer<Move> move2(move);
    //CPPUNIT_ASSERT_EQUAL(before+1, Move::getInstances());
    
  }
  CPPUNIT_ASSERT_EQUAL(before, Move::getInstances());
};


void
TestSmartPointer::test5()
{
  int before = Move::getInstances();
  Square a1(0,0);
  Square a2(0,1);
  {
    SmartPointer<Move> move = SimpleMove::createInstance(a1, a2);
    SmartPointer<Move> move2 ( SimpleMove::createInstance(a1, a2));
    //		CPPUNIT_ASSERT_EQUAL(before+2, Move::getInstances());
    move2 = move;
    
    //CPPUNIT_ASSERT_EQUAL(before+1, Move::getInstances());
    
  }
  CPPUNIT_ASSERT_EQUAL(before, Move::getInstances());
};



