# include "TestRepetitionSentry.h"
# include <string>
# include <Game/Game.h>
# include <Moves/SimpleMove.h>
# include <TranspositionTable/RepetitionSentry.h>
# include <Moves/CapturingMove.h>
using namespace Alice;
TestRepetitionSentry::TestRepetitionSentry(std::string name)
  : TestCase(name)
{

};

Test*
TestRepetitionSentry::suite()
{
  TestSuite* result = new TestSuite("TestRepetitionSentry");
  AddTest(result, TestRepetitionSentry, repetition);
  AddTest(result, TestRepetitionSentry, repetitionAfterCapture);
  return result;
};

void
TestRepetitionSentry::repetition()
{
  Game g;
  g.forsytheString("8/8/8/8/8/8/8/k6K/w");
  RepetitionSentry sentry;
  sentry.startObserving(&g);
  Square a1(0,0);
  Square a2(0,1);
  Square h1(7,0);
  Square h2(7,1);
  SmartPointer<Move> a1a2 = SimpleMove::createInstance(a1, a2);
  SmartPointer<Move> a2a1 = SimpleMove::createInstance(a2,a1);
  SmartPointer<Move> h1h2 = SimpleMove::createInstance(h1, h2);
  SmartPointer<Move> h2h1 = SimpleMove::createInstance(h2, h1);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  h1h2->makeOn(g);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  a1a2->makeOn(g);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  h2h1->makeOn(g);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  a2a1->makeOn(g);
  CPPUNIT_ASSERT(sentry.isRepeatedPosition());
  h1h2->makeOn(g);
  CPPUNIT_ASSERT(sentry.isRepeatedPosition());
};
void
TestRepetitionSentry::repetitionAfterCapture()
{
  Game g;
  g.forsytheString("8/8/8/8/8/8/7p/k6K/w");
  RepetitionSentry sentry;
  sentry.startObserving(&g);
  Square a1(0,0);
  Square a2(0,1);
  Square h1(7,0);
  Square h2(7,1);
  SmartPointer<Move> a1a2 = SimpleMove::createInstance(a1, a2);
  SmartPointer<Move> a2a1 = SimpleMove::createInstance(a2,a1);
  SmartPointer<Move> h1h2 = SimpleMove::createInstance(h1, h2);
  SmartPointer<Move> h2h1 = SimpleMove::createInstance(h2, h1);
  CapturingMove* h1xh2 = new CapturingMove(h1,h2);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  h1xh2->makeOn(g);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  a1a2->makeOn(g);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  h2h1->makeOn(g);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  a2a1->makeOn(g);
  CPPUNIT_ASSERT(!sentry.isRepeatedPosition());
  h1h2->makeOn(g);
  CPPUNIT_ASSERT(sentry.isRepeatedPosition());
};
