# include "TestGameRecord.h"
# include "Game/GameRecord.h"
# include "Moves/SanNotation.h"
# include "Algorithms/HashedAlphaBeta.h"
# include <Moves/SimpleMove.h>
# include <Moves/DoubleStep.h>
# include <sstream>
# include <fstream>
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( TestGameRecord );
void
TestGameRecord::construction()
{
  GameRecord record;
  CPPUNIT_ASSERT_EQUAL(std::string("?"), record.getTag("White"));
};

void
TestGameRecord::setTag()
{
  GameRecord record;
  record.setTag("White", "Kasparov, G.");
  CPPUNIT_ASSERT_EQUAL(std::string("Kasparov, G."), record.getTag("White"));
};


void
TestGameRecord::readTag()
{
  TagSet record;
  std::string tag("[Black \"A. Karpov\"]\n[White \"G. Kasparov\"]");
  std::istringstream stream(tag);
  record.readTag(stream);
  CPPUNIT_ASSERT_EQUAL(std::string("A. Karpov"), record.getTag("Black"));
  char c=0;
  while (c != '[')
    stream >> c;
  stream.putback(c);
  CPPUNIT_ASSERT_EQUAL(std::string("?"), record.getTag("White"));
  record.readTag(stream);
  CPPUNIT_ASSERT_EQUAL(std::string("G. Kasparov"), record.getTag("White"));
};

void
TestGameRecord::read()
{
  GameRecord record;
  std::string source;
  source += "[Black \"Stupid\"]\n";
  source += "[Result \"0-1\"]\n";
  source += "[White \"Dummy\"]\n";
  source += "1. f3 e5 2. g4 Qh4# 0-1\n";
  std::istringstream stream(source);
  record.read(stream);
  CPPUNIT_ASSERT_EQUAL(std::string("Dummy"), record.getTag("White"));
  CPPUNIT_ASSERT_EQUAL(std::string("Stupid"), record.getTag("Black"));
  CPPUNIT_ASSERT_EQUAL(4, record.plyCount());
  CPPUNIT_ASSERT_EQUAL(std::string("0-1"), record.getTag("Result"));
  CPPUNIT_ASSERT_EQUAL(std::string("rnb1kbnr/pppp1ppp/8/4p3/6Pq/5P2/PPPPP2P/RNBQKBNR/w"), record.getForsytheString(4));
  std::ostringstream out;
  record.write( out );
  std::string expected;
  expected += "[Event \"?\"]\n";
  expected += "[Site \"?\"]\n";
  expected += "[Date \"????.??.??\"]\n";
  expected += "[Round \"?\"]\n";
  expected += "[White \"Dummy\"]\n";
  expected += "[Black \"Stupid\"]\n";
  expected += "[Result \"0-1\"]\n";
  expected += "1. f3 e5 2. g4 Qh4# 0-1\n";
  CPPUNIT_ASSERT_EQUAL( expected, out.str() );
};

void
TestGameRecord::longGame()
{
  GameRecord record;
  std::ifstream source("/home/sven/Programming/Chess/Data/pgn/99DORT.PGN");
  CPPUNIT_ASSERT(source);
  record.read(source);
  CPPUNIT_ASSERT_EQUAL(std::string("Timman Jan H (NED)"), 
		       record.getTag("Black"));
  CPPUNIT_ASSERT_EQUAL(std::string("1-0"),record.getTag("Result"));

};

void
TestGameRecord::testStandardTags()
{
  std::string expected;
  expected += "[Event \"?\"]\n";
  expected += "[Site \"?\"]\n";
  expected += "[Date \"????.??.??\"]\n";
  expected += "[Round \"?\"]\n";
  expected += "[White \"?\"]\n";
  expected += "[Black \"?\"]\n";
  expected += "[Result \"*\"]\n";
  expected += "*\n";

  GameRecord record;
  std::ostringstream stream;
  record.write(stream);
  CPPUNIT_ASSERT_EQUAL( expected, stream.str());
};
