# include "TableEntryTestCase.h"
# include "TestHeader.h"
# include "Color.h"
# include "TranspositionTable/TableEntry.h"
# include "Moves/SimpleMove.h"
using namespace Alice;
void
TableEntryTestCase::creation()
{
  TableEntry entry;
  CPPUNIT_ASSERT_EQUAL(0, entry.cost());
  CPPUNIT_ASSERT_EQUAL(-1, entry.depth());
}

void
TableEntryTestCase::cutOffExact()
{
  TableEntry entry;
  Square a1(0, 0);
  Square a2(0, 1);
  Evaluation::Score dummy(0);
  SmartPointer<Move> move(SimpleMove::createInstance(a1, a2));
  CPPUNIT_ASSERT(entry.store(TableEntry::EXACT,
		     1, // cost
		     1, // depth
		     Evaluation::Score(0), // score
		     move, 0ll));
  CPPUNIT_ASSERT_EQUAL(Evaluation::Score(0), entry.score());
  CPPUNIT_ASSERT(entry.cutsOff(1,Evaluation::Score(1),Evaluation::Score(2),dummy));
  CPPUNIT_ASSERT(entry.cutsOff(1,Evaluation::Score(-2),Evaluation::Score(0),dummy));
  CPPUNIT_ASSERT(!entry.cutsOff(1,Evaluation::Score(-1), Evaluation::Score(1),dummy));
};
void
TableEntryTestCase::cutOffLower()
{
  TableEntry entry;
  Square a1(0, 0);
  Square a2(0, 1);
  SmartPointer<Move> move(  SimpleMove::createInstance(a1, a2));
  CPPUNIT_ASSERT(entry.store(TableEntry::LOWER,
		     1, // cost
		     1, // depth
		     Evaluation::Score(0), // score
		     move, 0ll));
  CPPUNIT_ASSERT_EQUAL(Evaluation::Score(0), entry.score());
  CPPUNIT_ASSERT(!entry.cutsOff(1,Evaluation::Score(1),Evaluation::Score(2)));
  CPPUNIT_ASSERT(entry.cutsOff(1,Evaluation::Score(-2),Evaluation::Score(0)));
  CPPUNIT_ASSERT(!entry.cutsOff(1,Evaluation::Score(-1), Evaluation::Score(1)));
};
void
TableEntryTestCase::cutOffUpper()
{
  TableEntry entry;
  Square a1(0, 0);
  Square a2(0, 1);
  SmartPointer<Move> move(  SimpleMove::createInstance(a1, a2));
  CPPUNIT_ASSERT(entry.store(TableEntry::UPPER,
		     1, // cost
		     1, // depth
		     Evaluation::Score(0), // score
		     move, 0ll));
  //CPPUNIT_ASSERT_EQUAL(short(0), entry.score());
  CPPUNIT_ASSERT(entry.cutsOff(1,Evaluation::Score(1),Evaluation::Score(2)));
  CPPUNIT_ASSERT(entry.cutsOff(1,Evaluation::Score(0),Evaluation::Score(2)));
  CPPUNIT_ASSERT(!entry.cutsOff(1,Evaluation::Score(-2),Evaluation::Score(0)));
  CPPUNIT_ASSERT(!entry.cutsOff(1,Evaluation::Score(-1),Evaluation::Score( 1)));
};

void
TableEntryTestCase::clear()
{
  // CPPUNIT_ASSERT(false);
  TableEntry entry;
  Square a1(0, 0);
  Square a2(0, 1);
  SmartPointer<Move> move(  SimpleMove::createInstance(a1, a2));
  CPPUNIT_ASSERT(entry.store(TableEntry::UPPER,
			     1, // cost
			     1, // depth
			     Evaluation::Score(0), // score
			     move, 0ll));
  entry.clear();
  CPPUNIT_ASSERT(0 == entry.cost());
  CPPUNIT_ASSERT(-1 == entry.depth());
};

Test*
TableEntryTestCase::suite()
{
  TestSuite* testSuite = new TestSuite("TableEntryTestCase");
  AddTest(testSuite, TableEntryTestCase, creation);
  AddTest(testSuite, TableEntryTestCase, cutOffExact);
  AddTest(testSuite, TableEntryTestCase, cutOffUpper);
  AddTest(testSuite, TableEntryTestCase, cutOffLower);
  AddTest(testSuite, TableEntryTestCase, clear);
  //AddTest(testSuite, TableEntryTestCase, fromForsytheLetter);
  return testSuite;
};
