# include "Pieces/Rook.h"
# include "RookTestCase.h"
# include "TestHeader.h"
# include "Color.h"
# include "Moves/Move.h"
# include "Game/Game.h"
# include "Directions/DirectionDown.h"
# include <Bitboard.h>
# include <list>
# include <sstream>
# include <iostream>
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( RookTestCase );
void
RookTestCase::moveGeneration()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/8/8/R7");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* rook = b.at(Square(0,0));
    rook->pseudolegalMoves(moves, Square(0,0), b, false);
  
    CPPUNIT_ASSERT_EQUAL(14, int(moves.size()));
    moves.clear();
  }
  {
    std::string forsythe("8/8/8/8/8/8/1R6/8");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* rook =  b.at(Square(1,1));
    rook->pseudolegalMoves(moves, Square(1,1), b, false);
//      for(list<Move*>::const_iterator it = moves.begin();
//  	it != moves.end(); ++ it){
//        (*it)->printOn(cout);
//        cout<<", ";
//      }
    //    cout<<endl;
    CPPUNIT_ASSERT_EQUAL(size_t(14), moves.size());
    moves.clear();
  }
};
void
RookTestCase::captures()
{
  Board b;
  {
    std::string forsythe("8/1p6/8/8/8/p1p5/qR6/1Rq5");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* rook =  b.at(Square(1,1));
    rook->pseudolegalMoves(moves, Square(1,1), b, false);
  
    CPPUNIT_ASSERT_EQUAL(12, int(moves.size()));
    moves.clear();
  }
};

void
RookTestCase::directions()
{
  Rook r(Color::white());
  Direction* down = new DirectionDown;
  CPPUNIT_ASSERT(down->isDown());
  CPPUNIT_ASSERT(down->isOrthogonal());
  CPPUNIT_ASSERT(r.movesInDirection(down));
};

void
RookTestCase::testAttacks()
{
  Board b;
  std::string forsythe("4k3/4r3/8/8/1p2R1P1/8/4K3/8/w");
  std::istringstream in(forsythe);
  b.readForsythe(in);
  Square e4(4,3);
  Bitboard expected = b.getAllPieces().getFileAttacks(e4.number());
  expected |= b.getAllPiecesRotated90().getRankAttacks(e4.number());
  Rook r( Color::white());
  Bitboard result = r.getAttacks(b, e4);
  CPPUNIT_ASSERT_EQUAL( expected, result );
};

void
RookTestCase::testClone()
{
  
  Piece* rook = Piece::newRook(Color::white());
  Piece* copy = rook->clone();
  CPPUNIT_ASSERT( copy );
  CPPUNIT_ASSERT( copy->isRook() );
  CPPUNIT_ASSERT( copy->color()->isWhite() );
};
