# include "QuiescenceSearchTestCase.h"
# include "TestHeader.h"
# include "Color.h"
# include "Game/Game.h"
# include "Game/Evaluation.h"
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( QuiescenceSearchTestCase );
void
QuiescenceSearchTestCase::simpleCapture()
{
  Game g;
  g.forsytheString("r6k/8/8/8/8/8/8/R6K/w");
  Evaluation eval;
  eval.startObserving(&g);
  QuiescenceSearch algo(g, &eval);
  algo.search(1);
  assert(g.forsytheString() == "r6k/8/8/8/8/8/8/R6K/w");
  CPPUNIT_ASSERT_EQUAL( Evaluation::Score(5), algo.score());
};
void
QuiescenceSearchTestCase::simpleCaptureWithFactor()
{
  Game g;
  g.forsytheString("r6k/8/8/8/8/8/8/R6K/w");
  Evaluation eval;
  eval.setBasicValue(1000);
  eval.startObserving(&g);
  QuiescenceSearch algo(g, &eval);
  algo.search(1);
  assert(g.forsytheString() == "r6k/8/8/8/8/8/8/R6K/w");
  CPPUNIT_ASSERT_EQUAL( Evaluation::Score(5000), algo.score());
};

void
QuiescenceSearchTestCase::testXRay()
{
  Game g;
  g.forsytheString("K6k/8/8/RQp4q/8/8/8/8/w");
  Evaluation eval;
  eval.setBasicValue( 1000 );
  eval.startObserving(&g);
  QuiescenceSearch algo(g, &eval);
  algo.search(1);
  CPPUNIT_ASSERT_EQUAL( Evaluation::Score(5000), algo.score() );
};


void
QuiescenceSearchTestCase::testXRay2()
{
  Game g;
  g.forsytheString("K6k/8/8/RQRp3q/8/8/8/3r4/w");
  Evaluation eval;
  eval.setBasicValue( 1000 );
  eval.startObserving(&g);
  QuiescenceSearch algo(g, &eval);
  algo.search(1);
  CPPUNIT_ASSERT_EQUAL( Evaluation::Score(5000), algo.score() );
};


void
QuiescenceSearchTestCase::test2()
{
  Game g;
  g.forsytheString("8/6K1/4N1NP/6k1/8/8/8/8/b");
  Evaluation eval;
  eval.startObserving(&g);
  QuiescenceSearch algo(g, &eval);
  algo.search(1);


};
