# include "Pieces/Queen.h"
# include "QueenTestCase.h"
# include "TestHeader.h"
# include "Color.h"
# include "Moves/Move.h"
# include "Game/Game.h"
# include <list>
# include <sstream>
# include <iostream>
using namespace Alice;
void
QueenTestCase::moveGeneration()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/8/8/Q7");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* queen = b.at(Square(0,0));
    queen->pseudolegalMoves(moves, Square(0,0), b, false);
  

    CPPUNIT_ASSERT_EQUAL(21, int(moves.size()));
    moves.clear();
  }
  {
    std::string forsythe("8/8/8/8/8/8/1Q6/8");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* queen = b.at(Square(1,1));
    queen->pseudolegalMoves(moves, Square(1,1), b, false);
//      for(list<Move*>::const_iterator it = moves.begin();
//  	it != moves.end(); ++ it){
//        (*it)->printOn(cout);
//        cout<<", ";
//      }
    //    cout<<endl;
    CPPUNIT_ASSERT_EQUAL(23, int(moves.size()));
    moves.clear();
  }
};
void
QueenTestCase::captures()
{
  Board b;
  {
    std::string forsythe("8/1p6/8/8/8/p1p5/qQ6/1Rq5");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* queen = b.at(Square(1,1));
    queen->pseudolegalMoves(moves, Square(1,1), b, false);
  
    CPPUNIT_ASSERT_EQUAL(16, int(moves.size()));
    moves.clear();
  }
};
Test*
QueenTestCase::suite()
{
  TestSuite* testSuite = new TestSuite("QueenTestCase");
  AddTest(testSuite, QueenTestCase, moveGeneration);
  AddTest(testSuite, QueenTestCase, captures);
  return testSuite;
};
