//////////////////////////////////////////////////
// (c) MMIII Sven Reichard
// 

# include <ProofNumberNodeTest.h>
CPPUNIT_TEST_SUITE_REGISTRATION( ProofNumberNodeTest );

void
ProofNumberNodeTest::constructor()
{

  ProofNumberNode node;
  CPPUNIT_ASSERT_EQUAL(1, node.getProofNumber() );
  CPPUNIT_ASSERT_EQUAL(1, node.getDisproofNumber() );
  CPPUNIT_ASSERT(! node.isExpanded() );
  CPPUNIT_ASSERT( node.needsExpansion() );
  CPPUNIT_ASSERT( node.isLegal() );
};

void
ProofNumberNodeTest::testExpand() 
{
  ProofNumberNode node;
  CPPUNIT_ASSERT_EQUAL(0, node.getNumberOfChildren() );
  node.expand(2);
  CPPUNIT_ASSERT_EQUAL(2, node.getNumberOfChildren() );
  CPPUNIT_ASSERT( node.isExpanded()  );
  ProofNumberNode* child0 = node.getChild(0);
  CPPUNIT_ASSERT( ! child0->isExpanded() );
  node.adjustNumbers();
  CPPUNIT_ASSERT_EQUAL(1, node.getProofNumber() );
  CPPUNIT_ASSERT_EQUAL(2, node.getDisproofNumber() );
};

void
ProofNumberNodeTest::testSetProven()
{
  ProofNumberNode node;
  node.setProven();
  CPPUNIT_ASSERT( ! node.needsExpansion() );
  CPPUNIT_ASSERT_EQUAL(0, node.getProofNumber() );
  CPPUNIT_ASSERT_EQUAL( ProofNumberNode::_INFINITY, node.getDisproofNumber());
  node.setDisproven();
  CPPUNIT_ASSERT( ! node.needsExpansion() );
  CPPUNIT_ASSERT_EQUAL(0, node.getDisproofNumber() );
  CPPUNIT_ASSERT_EQUAL( ProofNumberNode::_INFINITY, node.getProofNumber());
};

void
ProofNumberNodeTest::testChildToExpand()
{
  ProofNumberNode node;
  node.expand(2);
  node.adjustNumbers();
  CPPUNIT_ASSERT_EQUAL( 0, node.getChildToExpand() );
  node.getChild(0)->setProven();
  CPPUNIT_ASSERT_EQUAL( 1, node.getChildToExpand() );
};

void
ProofNumberNodeTest::testDepth()
{
  ProofNumberNode node;
  CPPUNIT_ASSERT_EQUAL(short(0), node.getDepth());
  CPPUNIT_ASSERT_EQUAL(short(0), node.getHeight());
  node.expand(2);
  node.adjustNumbers();
  CPPUNIT_ASSERT_EQUAL(short(1), node.getDepth());
  CPPUNIT_ASSERT_EQUAL(short(0), node.getHeight());
  CPPUNIT_ASSERT_EQUAL(short(1), node.getChild(0)->getHeight());
};
