//////////////////////////////////////////////////
// (c) MMIV Sven Reichard
// 

# include <PrincipalVariationTest.h>
# include <Moves/SimpleMove.h>
CPPUNIT_TEST_SUITE_REGISTRATION( PrincipalVariationTest );

void
PrincipalVariationTest::constructor()
{
  using namespace Alice;
  PrincipalVariation x;
  CPPUNIT_ASSERT_EQUAL(0, x.length());
};

void
PrincipalVariationTest::testNext()
{
  using namespace Alice;
  PrincipalVariation x;
  PrincipalVariation* y = x.next();
  CPPUNIT_ASSERT( y );
  CPPUNIT_ASSERT_EQUAL( 0, y->length() );
};

void
PrincipalVariationTest::testInsert()
{
  using namespace Alice;
  PrincipalVariation x;
  SmartPointer<Move> move = 
    SimpleMove::createInstance(Square(0,0), Square(0,1));
  x.insert( move );
  CPPUNIT_ASSERT_EQUAL( 1, x.length() );
  CPPUNIT_ASSERT( move == x.getMove(0) );
};

void
PrincipalVariationTest::testInsert2()
{
  using namespace Alice;
  PrincipalVariation x;
  PrincipalVariation* y = x.next();
  SmartPointer<Move> move1 = 
    SimpleMove::createInstance(Square(0,0), Square(0,1));
  SmartPointer<Move> move2 = 
    SimpleMove::createInstance(Square(0,0), Square(0,2));
  y->insert(move2);
  CPPUNIT_ASSERT_EQUAL( 0, x.length() );
  x.insert( move1 );
  CPPUNIT_ASSERT_EQUAL( 2, x.length() );
  CPPUNIT_ASSERT( move2 == x.getMove(1) );
};
