# include "PieceTestCase.h"
# include "TestHeader.h"
# include "Color.h"
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( PieceTestCase );
void
PieceTestCase::creation()
{
  Piece* k = Piece::newKing(Color::white());
  assert(k->color() == Color::white());
  CPPUNIT_ASSERT(k->isKing());
  delete k;
  Piece* b = Piece::newBishop(Color::white());
  CPPUNIT_ASSERT(b->isBishop());
  delete b;
  Piece* r = Piece::newRook(Color::white());
  CPPUNIT_ASSERT(r->isRook());
  delete r;
  Piece* q = Piece::newQueen(Color::black());
  CPPUNIT_ASSERT(q->isQueen());
  delete q;
  Piece* p = Piece::newPawn(Color::white());
  CPPUNIT_ASSERT(p->isPawn());
  delete p;
};

void
PieceTestCase::displayLetter()
{
  Piece* p = Piece::newKing(Color::white());
  CPPUNIT_ASSERT_EQUAL('K', p->displayLetter());
  delete p;
  p = Piece::newQueen(Color::white());
  CPPUNIT_ASSERT_EQUAL('Q', p->displayLetter());
  delete p;
  p = Piece::newBishop(Color::white());
  CPPUNIT_ASSERT_EQUAL('B', p->displayLetter());
  delete p;
  p = Piece::newRook(Color::white());
  CPPUNIT_ASSERT_EQUAL('R', p->displayLetter());
  delete p;
  p = Piece::newKnight(Color::white());
  CPPUNIT_ASSERT_EQUAL('N', p->displayLetter());
  delete p;
  p = Piece::newPawn(Color::white());
  CPPUNIT_ASSERT_EQUAL('P', p->displayLetter());
  delete p;
}

void
PieceTestCase::forsytheLetter()
{
  Piece* k = Piece::newKing(Color::white());
  CPPUNIT_ASSERT_EQUAL('K', k->forsytheLetter());
  delete k;
  k = Piece::newKing(Color::black());
  CPPUNIT_ASSERT_EQUAL('k', k->forsytheLetter());
  delete k;
  
  Piece* q = Piece::newQueen(Color::white());
  CPPUNIT_ASSERT_EQUAL('Q', q->forsytheLetter());
  delete q;
  q = Piece::newQueen(Color::black());
  CPPUNIT_ASSERT_EQUAL('q', q->forsytheLetter());
  delete q;
};

void
PieceTestCase::fromForsytheLetter()
{
  Piece* p;
  p = Piece::fromForsytheLetter('K');
  CPPUNIT_ASSERT_EQUAL('K',p->forsytheLetter());
  assert(p->isKing());
  delete p;
  p = Piece::fromForsytheLetter('q');
  CPPUNIT_ASSERT_EQUAL('q',p->forsytheLetter());
  delete p;
  p = Piece::fromForsytheLetter('B');
  CPPUNIT_ASSERT_EQUAL('B',p->forsytheLetter());
  delete p;
  p = Piece::fromForsytheLetter('n');
  CPPUNIT_ASSERT_EQUAL('n',p->forsytheLetter());
  delete p;
  p = Piece::fromForsytheLetter('R');
  CPPUNIT_ASSERT_EQUAL('R',p->forsytheLetter());
  delete p;
};


void
PieceTestCase::testClone()
{
  
  Piece* original = Piece::newRook(Color::white());
  Piece* copy = original->clone();
  CPPUNIT_ASSERT( copy );
  CPPUNIT_ASSERT( copy->isRook() );
  CPPUNIT_ASSERT( copy->color()->isWhite() );
  delete original;
  delete copy;

  original = Piece::newBishop(Color::black());
  copy = original->clone();
  CPPUNIT_ASSERT( copy );
  CPPUNIT_ASSERT( copy->isBishop() );
  CPPUNIT_ASSERT( copy->color()->isBlack() );
  delete original;
  delete copy;

  original = Piece::newQueen(Color::black());
  copy = original->clone();
  CPPUNIT_ASSERT( copy );
  CPPUNIT_ASSERT( copy->isQueen() );
  CPPUNIT_ASSERT( copy->color()->isBlack() );
  delete original;
  delete copy;

  original = Piece::newKnight(Color::white());
  copy = original->clone();
  CPPUNIT_ASSERT( copy );
  CPPUNIT_ASSERT( copy->isKnight() );
  CPPUNIT_ASSERT( copy->color()->isWhite() );
  delete original;
  delete copy;

  original = Piece::newPawn(Color::white());
  copy = original->clone();
  CPPUNIT_ASSERT( copy );
  CPPUNIT_ASSERT( copy->isPawn() );
  CPPUNIT_ASSERT( copy->color()->isWhite() );
  delete original;
  delete copy;
};
