# include "PawnTestCase.h"
# include "Pieces/Piece.h"
# include "TestHeader.h"
# include "Color.h"
# include "Moves/Move.h"
# include "Game/Game.h"
# include <list>
# include <sstream>
# include <iostream>
using namespace Alice;
void
PawnTestCase::moveGeneration()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/P7/8/8");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(0,2));
    pawn->pseudolegalMoves(moves, Square(0,2), b, false);
  
    CPPUNIT_ASSERT_EQUAL(1, int(moves.size()));
    moves.clear();
  }
  {
    std::string forsythe("8/8/8/8/8/k7/P7/8");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(0,1));
    pawn->pseudolegalMoves(moves, Square(0,1), b, false);
    for (MoveList::const_iterator it = moves.begin();
	 it != moves.end(); ++ it){
      //(*it)->printOn(cout);
      //cout<<", ";
    }
    //cout<<endl;
    CPPUNIT_ASSERT_EQUAL(0, int(moves.size()));
    moves.clear();
  }
};
void
PawnTestCase::captures()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/ppp5/1P6/8/");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(1,1));
    pawn->pseudolegalMoves(moves, Square(1,1), b, false);
  
    CPPUNIT_ASSERT_EQUAL(2, int(moves.size()));
    moves.clear();
  }
};

void
PawnTestCase::doubleStep()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/8/1P6/8/");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(1,1));
    pawn->pseudolegalMoves(moves, Square(1,1), b, false);
  
    CPPUNIT_ASSERT_EQUAL(2, int(moves.size()));
    
  }{
    std::string forsythe("8/p7/8/K7/8/8/8/8/");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(0,6));
    pawn->pseudolegalMoves(moves, Square(0,6), b, false);
  
    CPPUNIT_ASSERT_EQUAL(1, int(moves.size()));
    
  }
};


void
PawnTestCase::promotion()
{
  Board b;
  {
    std::string forsythe("8/3P4/8/8/8/8/8/8/");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(3,6));
    pawn->pseudolegalMoves(moves, Square(3,6), b, false);
  
    CPPUNIT_ASSERT_EQUAL(4, int(moves.size()));
  }{
    std::string forsythe("8/8/8/8/8/8/3p4/8/");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(3,1));
    pawn->pseudolegalMoves(moves, Square(3,1), b, false);
  
    CPPUNIT_ASSERT_EQUAL(4, int(moves.size()));
  }
  {
    std::string forsythe("2r1r3/3P4/8/8/8/8/8/8/");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* pawn =  b.at(Square(3,6));
    pawn->pseudolegalMoves(moves, Square(3,6), b, false);
  
    CPPUNIT_ASSERT_EQUAL(12, int(moves.size()));
    
  }
};


Test*
PawnTestCase::suite()
{
  TestSuite* testSuite = new TestSuite("PawnTestCase");
  AddTest(testSuite, PawnTestCase, moveGeneration);
  AddTest(testSuite, PawnTestCase, captures);
  AddTest(testSuite, PawnTestCase, doubleStep);
  AddTest(testSuite, PawnTestCase, promotion);
  return testSuite;
};
