# include <MoveTextTest.h>
# include <Game/MoveText.h>
# include <Moves/SimpleMove.h>
# include <Moves/DoubleStep.h>
# include <Moves/SanNotation.h>

CPPUNIT_TEST_SUITE_REGISTRATION( MoveTextTest);
using namespace Alice;
void
MoveTextTest::testAddMove()
{
  MoveText record;
  CPPUNIT_ASSERT_EQUAL(0, record.plyCount());
  bool success = record.addMove("e4");
  CPPUNIT_ASSERT(success);
  CPPUNIT_ASSERT_EQUAL(1, record.plyCount());
  success = record.addMove("e4");
  CPPUNIT_ASSERT(!success);
  CPPUNIT_ASSERT_EQUAL(1, record.plyCount());
  success = record.addMove("e5");
  CPPUNIT_ASSERT(success);
  CPPUNIT_ASSERT_EQUAL(2, record.plyCount());
};

void
MoveTextTest::testGetMove()
{
  MoveText record;
  std::string source;
  source += "1. f3 e5 2. g4 Qh4# 0-1\n";
  std::istringstream stream(source);
  record.read(stream);
  SmartPointer<Move> move0 = SimpleMove::createInstance(Square(5, 1), Square(5,2));
  CPPUNIT_ASSERT(*move0 == *record.getMove(0)); 
  DoubleStep* move2 = 
    DoubleStep::createInstance(Square(6,1), Square(6,3), Square(6,2));
  CPPUNIT_ASSERT(*move2 == *record.getMove(2));
};

void
MoveTextTest::testVariation()
{

  MoveText record;
  CPPUNIT_ASSERT( record.addMove("e4") );
  CPPUNIT_ASSERT( record.addMove("e5") );

  record.beginVariation();
  CPPUNIT_ASSERT( record.addMove("c5") );
  CPPUNIT_ASSERT( record.addMove("Nf3") );
  record.endVariation();
  CPPUNIT_ASSERT( record.addMove("Nf3") );
  std::ostringstream out;
  record.write(out);
  CPPUNIT_ASSERT_EQUAL(std::string("1. e4 e5 ( 1... c5 2. Nf3 ) 2. Nf3 "),
		       out.str());
};

void
MoveTextTest::testReadVariation()
{
  std::string source = "1. e4 e5 ( 1... c5 2. Nf3 ) 2. Nf3 ";
  std::istringstream input(source);
  MoveText record;
  record.read(input);
  std::ostringstream output;
  record.write( output );
  CPPUNIT_ASSERT_EQUAL( source, output.str());
};

void
MoveTextTest::testReadComment()
{
  MoveText record;
  std::string source;
  source += "1. f3 e5 2. g4 { not a good move } Qh4# ";
  std::istringstream input( source );
  record.read( input );
  std::ostringstream out;
  record.write( out );
  CPPUNIT_ASSERT_EQUAL( source, out.str() );
};

void
MoveTextTest::testEdit()
{
  MoveText record;
  CPPUNIT_ASSERT( record.addMove("e4") );
  CPPUNIT_ASSERT( record.addMove("c5") );
  CPPUNIT_ASSERT( record.addMove("Nf3") );
  std::string expected = "1. e4 c5 2. Nf3 ";
  std::ostringstream result1;
  //record.write( result1 );
  //CPPUNIT_ASSERT_EQUAL( expected, result1.str() );
  //  return;
  record.backward();
  //return;
  record.backward();
  CPPUNIT_ASSERT( record.addMove("e5") );
  std::ostringstream result2;
  record.write(result2);
  std::string expected2("1. e4 c5 ( 1... e5 ) 2. Nf3 ");
  CPPUNIT_ASSERT_EQUAL( expected2, result2.str());
};

void
MoveTextTest::testGetLastMove()
{
  
  MoveText record;
  CPPUNIT_ASSERT( record.addMove("e4"));
  SanNotation san = record.getLastMove();

  CPPUNIT_ASSERT_EQUAL( std::string("e4"), san.getString());
  //CPPUNIT_ASSERT( record.addMove("Nf6"));
};
