# ifndef MoveTestCase_h
# define MoveTestCase_h
#include "TestHeader.h"
# include "Moves/Move.h"
class MoveTestCase:
  public TestCase
{
public:
  CPPUNIT_TEST_SUITE( MoveTestCase );
  CPPUNIT_TEST(simpleMove );
  CPPUNIT_TEST(promotingMove );
  CPPUNIT_TEST(promotingCapture);
  CPPUNIT_TEST(castlingMove );
  CPPUNIT_TEST(equality );
  CPPUNIT_TEST( testIsLegal );
  CPPUNIT_TEST_SUITE_END();
protected:
  void simpleMove();
  void promotingMove();
  void promotingCapture();
  void castlingMove();
  void simpleMoveAllocation();
  void doTest(const std::string& before, const std::string& after,
	      Alice::Move& move);
  void equality();
  void testIsLegal();
};
#endif
