# include "KnightTestCase.h"
# include "TestHeader.h"
# include "Color.h"
# include "Moves/Move.h"
# include "Game/Game.h"
# include <list>
# include <sstream>
# include <iostream>
# include <Bitboard.h>
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( KnightTestCase );
void
KnightTestCase::moveGeneration()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/8/8/N7");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* knight =  b.at(Square(0,0));
    knight->pseudolegalMoves(moves, Square(0,0), b, false);
  
    CPPUNIT_ASSERT_EQUAL(2, int(moves.size()));
  }
  {
    std::string forsythe("8/8/8/8/8/8/1N6/8");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* knight =  b.at(Square(1,1));
    knight->pseudolegalMoves(moves, Square(1,1), b, false);
    CPPUNIT_ASSERT_EQUAL(4, int(moves.size()));
  }
};
void
KnightTestCase::captures()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/2N5/q7/1K1Q4");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* knight =  b.at(Square(2,2));
    knight->pseudolegalMoves(moves, Square(2,2), b, false);
  
    CPPUNIT_ASSERT_EQUAL(6, int(moves.size()));
  }
};

void
KnightTestCase::testAttacks()
{
  ShortMovingPiece* n = new Knight( Color::white() );
  Square sq(2,1);
  CPPUNIT_ASSERT_EQUAL( Bitboard::getKnightAttacks(sq),
			n->getAttacks( sq ) );
};
