# include "KingTestCase.h"
# include "TestHeader.h"
# include "Color.h"
# include "Moves/Move.h"
# include "Game/Game.h"
# include <Bitboard.h>
# include <list>
# include <sstream>
# include <iostream>
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( KingTestCase );
void
KingTestCase::moveGeneration()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/8/8/K7");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* king =  b.at(Square(0,0));
    king->pseudolegalMoves(moves, Square(0,0), b, false);
    assertLongsEqual(3, moves.size());
  }
  {
    std::string forsythe("8/8/8/8/8/8/1K6/8");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* king =  b.at(Square(1,1));
    king->pseudolegalMoves(moves, Square(1,1), b, false);
    assertLongsEqual(8, moves.size());
  }
};
void
KingTestCase::captures()
{
  Board b;
  {
    std::string forsythe("8/8/8/8/8/pPp5/qK6/1Rq5");
    std::istringstream in(forsythe);
    b.readForsythe(in);
    MoveList moves;
    const Piece* king =  b.at(Square(1,1));
    king->pseudolegalMoves(moves, Square(1,1), b, false);
  
    assertLongsEqual(6, moves.size());
  }
};

void
KingTestCase::testAttacks()
{
  Bitboard b;
  King* king = new King(Color::white());
  Square sq(0,0);
  CPPUNIT_ASSERT_EQUAL( Bitboard::getKingAttacks(sq), king->getAttacks(sq) );
};
