/***************************************************************************
                          EnPassantTestCase.cpp  -  description
                             -------------------
    begin                : Thu Aug 23 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

# include "TestHeader.h"
# include "Game/Game.h"
# include "Moves/DoubleStep.h"
#include "EnPassantTestCase.h"
# include "Moves/EnPassantMove.h"
# include <iostream>
using namespace Alice;
CPPUNIT_TEST_SUITE_REGISTRATION( EnPassantTestCase );
void
EnPassantTestCase::initial()
{
  assert(! sentry.square().isValid());
};

void
EnPassantTestCase::doubleStep()
{
  Game g;
  sentry.startObserving(&g);
  assert(!sentry.square().isValid());
  Square e2(4,1),
    e3(4,2),
    e4(4,3);
  DoubleStep* move = DoubleStep::createInstance(e2, e4, e3);
  move->makeOn(g);
  CPPUNIT_ASSERT(sentry.square().isValid());
  CPPUNIT_ASSERT(sentry.square() == e3);
  CPPUNIT_ASSERT(g.epSquare() == e3);
  CPPUNIT_ASSERT_EQUAL( std::string("e3"), sentry.getEPDString());
  move->takeBackOn(g);
  CPPUNIT_ASSERT(!sentry.square().isValid());
  CPPUNIT_ASSERT_EQUAL( std::string("-"), sentry.getEPDString());
  delete move;
	
};

void
EnPassantTestCase::doMove()
{
  Game g;
  g.forsytheString("k7/8/8/8/p7/8/1P6/K7/w");
  std::string before(g.forsytheString());
  Square b2(1,1),a4(0,3), b4(1,3), b3(1,2);
  DoubleStep* ds = DoubleStep::createInstance(b2, b4, b3);
  EnPassantMove move(a4, b3, b4);
  ds->makeOn(g);
  move.makeOn(g);
  std::string after("k7/8/8/8/8/1p6/8/K7/w");
  CPPUNIT_ASSERT(g.forsytheString() == after);
  move.takeBackOn(g);
  ds->takeBackOn(g);
  CPPUNIT_ASSERT(g.forsytheString() == before);
};
