# include "DirectionTestCase.h"
# include "Square.h"
# include "TestHeader.h"
# include "Board.h"
# include <Directions/Direction.h>
# include <list>
# include <sstream>
# include <iostream>

CPPUNIT_TEST_SUITE_REGISTRATION( DirectionTestCase );

using namespace Alice;
void
DirectionTestCase::blockedSquare()
{
  Board b;
  std::string forsythe("8/1q6/8/8/8/8/8/8/");
  std::istringstream in(forsythe);
  b.readForsythe(in);
  Square sq(0,0);
  const Direction& up = Direction::up();
  Square block = up.blockedSquareFrom(sq, b);
  CPPUNIT_ASSERT(!block.isValid());
  sq = Square(1,0);
  block = up.blockedSquareFrom(sq, b);
  CPPUNIT_ASSERT(block.isValid());
  CPPUNIT_ASSERT(block == Square(1,6));
};

void
DirectionTestCase::knightDirections()
{
  for (int i = 0; i < 8; i++)
    for (int j = 0; j < 8; j++)
      for (int k = 0; k < 8; k++)
	for (int l = 0; l < 8; l++) {
	  Square source(i, j);
	  Square destination(k, l);
	  const Direction* dir = &source.directionTo(destination);
	  if (dir->isKnightDirection())
	    CPPUNIT_ASSERT(destination == dir->appliedTo(source));
	   //delete dir;
	}
};


void
DirectionTestCase::allInstances()
{
  assertLongsEqual(16,Direction::allInstances().size());
};
