/***************************************************************************
                          CastlingTestCase.h  -  description
                             -------------------
    begin                : Sun Sep 2 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CASTLINGTESTCASE_H
#define CASTLINGTESTCASE_H

#include <TestHeader.h>

/**
  *@author Sven Reichard
  */

class CastlingTestCase : public TestCase  {
public: 
	CastlingTestCase(std::string name=""):TestCase(name){};
	~CastlingTestCase();
	static Test		*suite ();
protected:
	void basic();
  /** make sure we can't castle if any pieces
are between the king and the rook. */
  void obstructed();
  /** don't allow castling when in check */
  void inCheck();
  /** don't  castle across an attacked square */
  void attacked();
  /** check that castling isn't allowed if any
of the involved pieces have moved. */
  void moved();
  /** see if castling is properly generated */
  void generate();
  void testHasCastled();
};

#endif
