//////////////////////////////////////////////////
// (c) MMIII Sven Reichard
// 

# include <BookTrainingTest.h>
CPPUNIT_TEST_SUITE_REGISTRATION( BookTrainingTest );

using namespace Alice;
using namespace Alice::XBoard;

void
BookTrainingTest::constructor()
{
  std::string source;
  source += "go\n";
  source += "usermove c5\n";

  std::istringstream input( source );
  std::ostringstream output;
  BookTraining training( input, output );
  std::string book("e4 e5 ( c5 Nf3 ) Nc3");
  std::istringstream bookStream( book );
  training.readBook( bookStream );
  std::string expected;
  CPPUNIT_ASSERT_EQUAL( std::string(""), output.str() );
  training.acceptFeature("san");
  training.acceptFeature("usermove");
  training.processCommand();
  expected += "move e4\n";
  CPPUNIT_ASSERT_EQUAL( expected, output.str() );
  training.processCommand();
  expected += "move Nf3\n";
  CPPUNIT_ASSERT_EQUAL( expected, output.str() );

};

