// -*- c++ -*-

//////////////////////////////////////////////////
// (c) MMIII Sven Reichard
// 

# ifndef BitboardTest_h
# define BitboardTest_h
# include <cppunit/extensions/HelperMacros.h>
# include <Bitboard.h>
class BitboardTest
  : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( BitboardTest );
  CPPUNIT_TEST( testGetByte );
  CPPUNIT_TEST( testGetRooks );
  CPPUNIT_TEST( testFirstBit );
  CPPUNIT_TEST( testLastBit );
  CPPUNIT_TEST( testIterator );
  CPPUNIT_TEST( testFileAttacks );
  CPPUNIT_TEST( testRotatedNumber );
  CPPUNIT_TEST( testRotated90 );
  CPPUNIT_TEST( testSetRank );
  CPPUNIT_TEST( testRankMask );
  CPPUNIT_TEST( testRankAttacks );
  CPPUNIT_TEST( testKnightAttacks );
  CPPUNIT_TEST( testKingAttacks );
  CPPUNIT_TEST( testDownDiagonalMasks );
  CPPUNIT_TEST( testRotated45 );
  CPPUNIT_TEST( testRotated135 );
  CPPUNIT_TEST( testUpDiagonalMask );
  CPPUNIT_TEST( testUpDiagonalAttacks );
  CPPUNIT_TEST( testDownDiagonalAttacks );
  CPPUNIT_TEST_SUITE_END();
protected:
  void testGetByte();
  void testGetRooks();
  void testFirstBit();
  void testLastBit();
  void testIterator();
  void testFileAttacks();
  void testRotatedNumber();
  void testRotated90();
  void testSetRank();
  void testRankMask();
  void testRankAttacks();
  void testKnightAttacks();
  void testKingAttacks();
  void testDownDiagonalMasks();
  void testRotated45();
  void testRotated135();
  void testUpDiagonalMask();
  void testUpDiagonalAttacks();
  void testDownDiagonalAttacks();
};
# endif // BitboardTest_h
