# include "AlphaBetaTestCase.h"
# include "TestHeader.h"
# include "Color.h"
# include "Game/Game.h"
# include "Algorithms/AlphaBetaWithQSearch.h"
using namespace Alice;
void
AlphaBetaTestCase::simpleCapture()
{
  Game g;
  g.forsytheString("r6k/8/8/8/8/8/8/R6K/w");
  AlphaBetaWithQSearch algo(g);
  algo.search(1);
  CPPUNIT_ASSERT(g.forsytheString() == "r6k/8/8/8/8/8/8/R6K/w");
  //Evaluation::Score actual(algo.score());
  Evaluation::Score wanted = 5;
  CPPUNIT_ASSERT_EQUAL( wanted,  algo.score());
};
void
AlphaBetaTestCase::fork()
{
  Game g;
  g.forsytheString("1k6/8/8/8/8/1n6/8/Q1K5/w");
  AlphaBetaWithQSearch algo(g);
  algo.search(2);
  CPPUNIT_ASSERT_EQUAL(0, algo.getHeight());
  CPPUNIT_ASSERT(g.forsytheString() == "1k6/8/8/8/8/1n6/8/Q1K5/w");
  CPPUNIT_ASSERT_EQUAL( Evaluation::Score(0), algo.score());
};
void
AlphaBetaTestCase::fork2()
{
  Game g;
  g.forsytheString("r3k3/8/N7/8/8/8/8/7K/w");
  AlphaBetaWithQSearch algo(g);
  algo.search(3);
  CPPUNIT_ASSERT(g.forsytheString() == "r3k3/8/N7/8/8/8/8/7K/w");
  CPPUNIT_ASSERT_EQUAL( Evaluation::Score(3), algo.score());
};

void
AlphaBetaTestCase::simpleCaptureWithFactor()
{
  Game g;
  g.forsytheString("r6k/8/8/8/8/8/8/R6K/w");
  AlphaBetaWithQSearch algo(g);
  Evaluation eval;
  eval.setBasicValue(1000);
  algo.setEvaluation(&eval);
  algo.search(1);
  CPPUNIT_ASSERT(g.forsytheString() == "r6k/8/8/8/8/8/8/R6K/w");
  CPPUNIT_ASSERT_EQUAL( Evaluation::Score(5000), algo.score());
};

void
AlphaBetaTestCase::twoGames()
{
  Game g;
  //std::cerr<<"-------- game 1: "<<&g<<std::endl;
  AlphaBetaWithQSearch algo(g);
    
  {
    g.forsytheString("1k6/8/8/8/8/1n6/8/Q1K5/w");
    algo.setGame(g);
    algo.search(2);
    CPPUNIT_ASSERT_EQUAL(0, algo.getHeight());
    CPPUNIT_ASSERT(g.forsytheString() == "1k6/8/8/8/8/1n6/8/Q1K5/w");
    CPPUNIT_ASSERT( Evaluation::Score(0) == algo.score());
  }
  {
    Game g2;
    //std::cerr<<"-------- game 2: "<<&g2<<std::endl;
    g2.forsytheString("r3k3/8/N7/8/8/8/8/7K/w");
    algo.setGame(g2);
    algo.search(3);
    
    CPPUNIT_ASSERT(g2.forsytheString() == "r3k3/8/N7/8/8/8/8/7K/w");
    CPPUNIT_ASSERT( Evaluation::Score(3) == algo.score());
    algo.setGame(g);
  }
  
};

Test*
AlphaBetaTestCase::suite()
{
  TestSuite* testSuite = new TestSuite("AlphaBetaTestCase");
  AddTest(testSuite, AlphaBetaTestCase, simpleCapture);
  AddTest(testSuite, AlphaBetaTestCase, fork);
  AddTest(testSuite, AlphaBetaTestCase, fork2);
  AddTest(testSuite, AlphaBetaTestCase, simpleCaptureWithFactor);
  AddTest(testSuite, AlphaBetaTestCase, twoGames);
  return testSuite;
};
