# include <XBoard/TimeControl.h>

using namespace Alice::XBoard;
void
TimeControl::setTimeIncrement( int x )
{
  timeIncrement = x;
};

int
TimeControl::getTimeIncrement() const
{
  return timeIncrement;
};

void
TimeControl::setTimeControl( int minutes, int increment)
{

  setTimeIncrement(increment);
  secondsPerSession = minutes * 60;
  limitType = NORMAL;
};

int
TimeControl::getSecondsPerSession() const
{
  return secondsPerSession;
};

void
TimeControl::setSecondsPerSession( int x )
{
  secondsPerSession = x;
};

double
TimeControl::timeToSearch( int movesSoFar ) const
{
  if ( getTimeIncrement() )
    return 1.0*getOwnTime()/20/300;
  if (getMovesPerSession() == 0)
    return 1.0*getOwnTime()/20/300;
  return 1.0*getOwnTime()/(getMovesPerSession()-movesSoFar + 3)/300;
};
