/***************************************************************************
                          ShortMovingPiece.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/ShortMovingPiece.h"
# include "Directions/Direction.h"
# include "Square.h"
# include "Moves/CapturingMove.h"
# include "Moves/SimpleMove.h"
# include "Board.h"
# include "Color.h"

using namespace Alice;
ShortMovingPiece::ShortMovingPiece(Color* color, char dLetter):
  Piece(color, dLetter)
{};

ShortMovingPiece::~ShortMovingPiece()
{};


void 
ShortMovingPiece::pseudoLegalMovesInDirection(MoveList& moves,
					      const Square& sq,
					      const Board& b, 
					      bool capturesOnly, 
					      const Direction* dir) const
{
  Square destination (dir->appliedTo(sq));
  if (!destination.isValid())
    return;
  if(b.at(destination)->color() == color()->otherColor())
    {
      Move* capture = new CapturingMove(sq, destination);
      moves.push_back(capture);
      return;
    }
  if ((capturesOnly) || (b.at(destination)->color() != 0))
    return;
  moves.push_back(SimpleMove::createInstance(sq, destination));
};

void 
ShortMovingPiece::pseudolegalMoves(MoveList& moves, 
		       const Square& sq, 
		       const Board& board,
		       bool capturesOnly)const
{

  Bitboard attacks = getAttacks(sq);
  Bitboard ownPieces = (color() == Color::white()? 
			board.getWhitePieces(): board.getBlackPieces());
  Bitboard otherPieces = (color() == Color::white()? 
			board.getBlackPieces(): board.getWhitePieces());
  if (capturesOnly)
    attacks &= otherPieces;
  else
    attacks &= ~ownPieces;
  for (Bitboard::Iterator it(attacks); it; ++ it )
    {
      Square dest(*it);
      if (otherPieces[dest])
	moves.push_back(new CapturingMove(sq, dest));
      else
	moves.push_back(SimpleMove::createInstance( sq, dest ) );
    };
};
