/***************************************************************************
                          Rook.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/Rook.h"
# include "Directions/Direction.h"
# include <Bitboard.h>
# include <Board.h>
# include <list>
# include <Moves/CapturingMove.h>
# include <Moves/SimpleMove.h>

using namespace Alice;
Rook::Rook(Color* aColor):
  LongMovingPiece(aColor, 'R')
{};

Rook::~Rook()
{};

char
Rook::displayLetter() const
{
  return 'R';
};

std::list<const Direction*>
Rook::mDirections;

const std::list<const Direction*>& 
Rook::directions() const
{
  static bool initialized(false);
  if (! initialized){
    initialized = true;
    mDirections.push_back(&Direction::up());
    mDirections.push_back(&Direction::down());
    mDirections.push_back(&Direction::left());
    mDirections.push_back(&Direction::right());
  }
  return mDirections;
};

bool
Rook::movesInDirection(const Direction* dir) const
{
  return dir->isOrthogonal();
};
Evaluation::Score 
Rook::basicValue() const
{
  return Evaluation::Score(5);
};
/**  */
bool Rook::isRook() const{
	return true;
}

int
Rook::centralizationFactor() const
{
  return 2;
};

Bitboard
Rook::getAttacks( const Board& b, const Square& sq ) const
{
  Bitboard result = b.getAllPieces().getFileAttacks(sq.number());
  result |= b.getAllPiecesRotated90().getRankAttacks(sq.number());
  return result;
};

Piece*
Rook::clone() const
{
  return new Rook(color() );
};
