# include <TranspositionTable/RepetitionSentry.h>
# include <Moves/Move.h>
# include <cassert>
using namespace Alice;

RepetitionSentry::RepetitionSentry()
  : HashTable(14),
    entries(1<<14)
{
  Entry& entry = entries[currentCode().primary()];
  entry.identifier = currentCode().secondary();
  entry.occurences = 1;
};

RepetitionSentry::~RepetitionSentry()
{
};

bool
RepetitionSentry::isRepeatedPosition()
{
  assert(currentCode().primary() < entries.size());
  Entry& entry = entries[currentCode().primary()];
  if (entry.identifier != currentCode().secondary())
    return false;
  return entry.occurences > 1;
};

void
RepetitionSentry::update()
{
  assert(currentCode().primary() < entries.size());
  Entry& entry=entries[currentCode().primary()];
  if (entry.occurences == 0)
    entry.identifier = currentCode().secondary();
  if (entry.identifier == currentCode().secondary())
    entry.occurences ++;
};

void 
RepetitionSentry::downdate()
{
  
  assert(currentCode().primary() < entries.size());
  Entry& entry=entries[currentCode().primary()];
  if (entry.identifier == currentCode().secondary())
    entry.occurences --;
};

