/***************************************************************************
                          Queen.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/Queen.h"

# include "Directions/Direction.h"
# include <Board.h>
using namespace Alice;
Queen::Queen(Color* aColor):
  LongMovingPiece(aColor,'Q')
{};

Queen::~Queen()
{};

char
Queen::displayLetter() const
{
  return 'Q';
};

std::list<const Direction*>
Queen::mDirections;
const std::list<const Direction*>&
Queen::directions() const
{
  static bool initialized(false);
  if (! initialized){
    initialized = true;
    mDirections.push_back(& Direction::up());
    mDirections.push_back(& Direction::down());
    mDirections.push_back(& Direction::left());
    mDirections.push_back(& Direction::right());
    mDirections.push_back(& Direction::upLeft());
    mDirections.push_back(& Direction::upRight());
    mDirections.push_back(& Direction::downLeft());
    mDirections.push_back(& Direction::downRight());
  }
  return mDirections;
};

bool
Queen::movesInDirection(const Direction* dir) const
{
  return dir->isDiagonal() || dir->isOrthogonal();
};

Evaluation::Score 
Queen::basicValue() const
{
  return Evaluation::Score(9);
};

int
Queen::centralizationFactor() const
{
  return 2;
}; 


Bitboard
Queen::getAttacks( const Board& b, const Square& sq ) const
{
  Bitboard result = b.getAllPieces().getFileAttacks(sq.number());
  result |= b.getAllPiecesRotated90().getRankAttacks(sq.number());
  result |= b.getAllPiecesRotated45().getDownDiagonalAttacks(sq);
  result |= b.getAllPiecesRotated135().getUpDiagonalAttacks(sq);
  return result;
};

Piece*
Queen::clone() const
{
  return newQueen( color () );
};
