/***************************************************************************
                          PromotingMove.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Moves/PromotingMove.h"
# include "Moves/SanNotation.h"
# include "Board.h"
# include "Pieces/Piece.h"
# include "Game/GameObserver.h"
using namespace Alice;
PromotingMove::PromotingMove(const Square& from, const Square& to, 
			     const Piece* promoted):
  Move(from, to), 
  mPromoted(promoted)
{};

PromotingMove::~PromotingMove()
{
  delete mPromoted;
};

void
PromotingMove::makeOn(Board& b)
{
  b.put(mPromoted->clone(), destination());
  delete b.at(source());
  b.clear(source());
};
void
PromotingMove::takeBackOn(Board& b)
{
  b.put(Piece::newPawn(mPromoted->color()), source());
  delete b.at(destination());
  b.clear(destination());
};
void
PromotingMove::makeOn(GameObserver& b)
{
  b.doPromotingMove(*this);
};
void
PromotingMove::takeBackOn(GameObserver& b)
{
  b.takeBackPromotingMove(*this);
};
void
PromotingMove::printOn(std::ostream& out) const
{
  out<<char('a'+source().file())<<char('1'+source().rank());
  out<<'-';
  out<<char('a'+destination().file())<<char('1'+destination().rank());
  out<<'='<<mPromoted->displayLetter();
};

void
PromotingMove::modifySan(SanNotation& san) const
{
	san.setPromotion(promotedPiece()->displayLetter());
};

bool
PromotingMove::fitsDescription(const SanNotation& san) const
{
  if (!Move::fitsDescription(san))
    return false;
  const PromotingMove* otherMove 
    = dynamic_cast<const PromotingMove*>(&*san.getMove());
  return promotedPiece()->displayLetter() ==
    otherMove->promotedPiece()->displayLetter();
};

bool
PromotingMove::operator==(const Move& move) const
{
  return move.equalsPromotingMove(*this);
};

bool
PromotingMove::equalsPromotingMove(const PromotingMove& move) const
{
  return (source() == move.source()) &&
    (destination() == move.destination()) &&
    (promotedPiece()->displayLetter() == move.promotedPiece()->displayLetter());
};
