/***************************************************************************
                          PromotingCapture.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Moves/PromotingCapture.h"
# include "Moves/SanNotation.h"
# include "Board.h"
# include "Pieces/Piece.h"
# include "Game/GameObserver.h"
# include <Game/Game.h>
using namespace Alice;

PromotingCapture::PromotingCapture(const Square& from, const Square& to, 
			     const Piece* promoted):
  Move(from, to), 
  mPromoted(promoted)
{};

PromotingCapture::~PromotingCapture()
{
  if (mPromoted)
    delete mPromoted;
};

void
PromotingCapture::makeOn(Board& b)
{
  mCapture = b.at(destination());
  b.clear( destination() );
  b.put(mPromoted->clone(), destination());
  delete b.at(source());
  b.clear(source());
};
void
PromotingCapture::takeBackOn(Board& b)
{
  b.put(Piece::newPawn(mPromoted->color()), source());
  //mPromoted = b.at(destination());
  b.clear(destination());
  b.put(mCapture, destination());
};

void
PromotingCapture::makeOn(GameObserver& b)
{
  b.doPromotingCapture(*this);
};
void
PromotingCapture::takeBackOn(GameObserver& b)
{
  b.takeBackPromotingCapture(*this);
};

void
PromotingCapture::printOn(std::ostream& out) const
{
  out<<char('a'+source().file())<<char('1'+source().rank());
  out<<'x';
  out<<char('a'+destination().file())<<char('1'+destination().rank());
  out<<'='<<(mPromoted?mPromoted->displayLetter():'?');
};
void
PromotingCapture::modifySan(SanNotation& san) const
{
	san.setPromotion(promotedPiece()->displayLetter());
};

bool
PromotingCapture::isLegal( const Game& g ) const
{
  if (! Move::isLegal( g ) )
    return false;
  const Piece* capturedPiece = g.board().at(destination());
  return !capturedPiece->isNull();
};
