//////////////////////////////////////////////////
// (c) MMIV Sven Reichard
// 

# include <PrincipalVariation.h>
using namespace Alice;
PrincipalVariation::PrincipalVariation()
  : mNext( 0 )
{

};

PrincipalVariation::~PrincipalVariation()
{
  delete mNext;
};

int
PrincipalVariation::length() const
{
  return moves.size();
};

PrincipalVariation*
PrincipalVariation::next()
{
  if (mNext == 0)
    mNext = new PrincipalVariation;
  return mNext;
};

void
PrincipalVariation::insert( const SmartPointer<Move>& move )
{
  moves.resize(1);
  moves[0] = move;
  if (mNext)
    std::copy(mNext->moves.begin(), mNext->moves.end(),
	      std::back_inserter(moves));
};

SmartPointer<Move>
PrincipalVariation::getMove( int which ) const
{
  return moves.at( which );
};

void
PrincipalVariation::clear()
{
  moves.clear();
};

void
PrincipalVariation::printTo( std::ostream& out ) const
{
  for (int i = 0; i < moves.size(); i++)
    {
      moves[i]->printOn(out);
      out<<" ";
    }
  out<<std::endl;
};
