# include <Game/PiecePlacementFeature.h>
# include <Game/Game.h>
# include <numeric>
using namespace Alice;

PiecePlacementFeature::PiecePlacementFeature()
  : EvaluationFeature(MAX_WEIGHT, "piecePlacement")
{

};

void
PiecePlacementFeature::computeGradient(Game* g)
{

  clearGradient();
  for (int i = 0; i < 64; i++)
    {
      Square sq(i);
      const Piece* p = g->board().at(sq);
      if (p->isNull())
	continue;
      int file = sq.file();
      int rank = sq.rank();
      if (p->color()->isBlack())
	rank = 7-rank;
      Square adjustedSquare (file, rank);
      int pieceType;
      switch(p->displayLetter())
	{
	case 'K': pieceType = KING; break;
	case 'Q': pieceType = QUEEN; break;
	case 'R': pieceType = ROOK; break;
	case 'B': pieceType = BISHOP; break;
	case 'N': pieceType = KNIGHT; break;
	case 'P': pieceType = PAWN; break;

	}
      int factor = 1;
      if (p->color()->isBlack())
	factor = -1;
      addGradient(pieceType + adjustedSquare.number(), factor);
    }
};

