/***************************************************************************
                          Piece.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/Piece.h"
# include "Pieces/King.h"
# include "Pieces/Queen.h"
# include "Pieces/Rook.h"
# include "Pieces/Bishop.h"
# include "Pieces/Knight.h"
# include "Pieces/Pawn.h"
# include "Pieces/NullPiece.h"
# include "Color.h"
# include <ctype.h>
using namespace Alice;

Piece::Piece(Color* aColor, char dLetter):
  mIsNull(false),
  mColor(aColor),
  mDisplayLetter(dLetter)
{};

Piece::~Piece()
{};

Piece*
Piece::newKing(Color* aColor)
{
  return new King(aColor);
};
Piece*
Piece::newQueen(Color* aColor)
{
  return new Queen(aColor);
};

Piece*
Piece::newRook(Color* aColor)
{
  return new Rook(aColor);
};
Piece*
Piece::newBishop(Color* aColor)
{
  return new Bishop(aColor);
};
Piece*
Piece::newKnight(Color* aColor)
{
  return new Knight(aColor);
};
Piece*
Piece::newPawn(Color* aColor)
{
  return new Pawn(aColor);
};
Piece*
Piece::newNullPiece()
{
  return new NullPiece();
};

Piece*
Piece::fromForsytheLetter(char c)
{
  Color * color = isupper(c) ?
    Color::white():
    Color::black();
  Piece *p=0;
  switch(tolower(c)) {
  case 'k': p = newKing(color); break;
  case 'q': p = newQueen(color); break;
  case 'r': p = newRook(color); break;
  case 'b': p = newBishop(color); break;
  case 'n': p = newKnight(color); break;
  case 'p': p = newPawn(color); break;
  default: std::cerr<<"unknown piece "<<c<<std::endl;
    exit(1);
  };
  return p;
};

char 
Piece::forsytheLetter() const
{
  if(mColor==Color::white())
    return displayLetter();
  return tolower(displayLetter());
};


bool
Piece::isKing() const
{
  return false;
};

bool
Piece::isQueen() const

{
  return displayLetter() == 'Q';
};

bool
Piece::isRook() const
{
  return false;
};

bool
Piece::isBishop() const
{
  return false;
};

bool
Piece::isKnight() const
{
  return false;
};





void 
Piece::pseudolegalMoves (MoveList &, 
			 const Square &, const Board &, bool capturesOnly) const
{};

bool
Piece::movesInDirection(const Direction* dir) const
{
  return false;
};

Evaluation::Score 
Piece::basicValue() const
{
  return Evaluation::Score(0);
};

int
Piece::centralizationFactor() const
{
  return 0;
};
