//////////////////////////////////////////////////
// (c) MMIII Sven Reichard
// 

# include <Perft.h>
# include <Moves/Move.h>
# include <Pieces/Piece.h>
# include <Game/Game.h>
namespace Alice
{
  Perft::Perft(Game& g, int maxDepth)
    : game( g ),
      maxDepth( maxDepth ),
      nodes( maxDepth + 1 )
  {
    
  };
  
  Perft::~Perft()
  {
    
  };

  int
  Perft::getMaxDepth() const
  {
    return maxDepth;
  };

  void
  Perft::search()
  {
    recursion(0);
  };

  int 
  Perft::getNodesAtDepth( int d ) const
  {
    return nodes[d];
  };

  void
  Perft::recursion( int d )
  {
    nodes[d] ++;
    if (d >= getMaxDepth())
      return;
    MoveList moves;
    game.pseudoLegalMoves(moves);
    for (MoveList::iterator it = moves.begin();
	 it != moves.end(); ++ it)
      {
	(*it)->makeOn(game);
	if (game.isInCheck(game.colorToMove()->otherColor()))
	  {
	    (*it)->takeBackOn( game );
	    continue;
	  }
	recursion(d+1);
	(*it)->takeBackOn( game );
	


      }
    
  };
}
