/***************************************************************************
                          MDTf.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Algorithms/MDTf.h"
using namespace Alice;

MDTf::MDTf(Game& g):
  HashedAlphaBeta(g)
{
  mScore = Evaluation::stalemate();
};

MDTf::~MDTf()
{};

void
MDTf::searchFixedDepth(int depth)
{
  Score result = recursiveSearch(depth, Score(mScore-1), mScore);
  std::cout<<"\t-- "<<result<<"  ";
  printPV(std::cout);
  if (result >= mScore){
    mScore = result;
    while(true) {
      result = recursiveSearch(depth, mScore, Score(mScore + 1));
      std::cout<<"\t "<<(result == mScore? '=':'>')<<
		  " "<<result<<"  ";
      printPV(std::cout);
      if (result <= mScore) {
	break;
      };
      mScore = result;
    }
  }
  else {
    mScore = result;
    while(true) {
      result = recursiveSearch(depth, Score(mScore-1), mScore);
      std::cout<<"\t < "<<result<<"  ";
      printPV(std::cout);
      if (result >= mScore) {
	break;
      };
      mScore = result;
    }
  }
  mBestMove = ttable.bestMove();
  
};
