/***************************************************************************
                          LongMovingPiece.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/LongMovingPiece.h"
# include "Board.h"
# include "Square.h"
# include "Directions/Direction.h"
# include "Moves/SimpleMove.h"
# include "Moves/CapturingMove.h"
# include <list>
using namespace Alice;

LongMovingPiece::LongMovingPiece(Color* color, char dLetter):
  Piece(color, dLetter)
{};

LongMovingPiece::~LongMovingPiece()
{};
void 
LongMovingPiece::pseudolegalMoves (MoveList& moves, 
			const Square& sq, const Board& board,
			bool capturesOnly) const
{
  Bitboard attacks = getAttacks(board, sq);
  Bitboard ownPieces = (color() == Color::white()? 
			board.getWhitePieces(): board.getBlackPieces());
  Bitboard otherPieces = (color() == Color::white()? 
			board.getBlackPieces(): board.getWhitePieces());
  if (capturesOnly)
    attacks &= otherPieces;
  else
    attacks &= ~ownPieces;
  for (Bitboard::Iterator it(attacks); it; ++ it )
    {
      Square dest(*it);
      if (otherPieces[dest])
	moves.push_back(new CapturingMove(sq, dest));
      else
	moves.push_back(SimpleMove::createInstance( sq, dest ) );
    };

  return;
  //////////////////////

  const std::list<const Direction*>& dirs(directions());
  for (std::list<const Direction*>::const_iterator direction = dirs.begin();
       direction != dirs.end();
       ++direction){
    Square destination((*direction)->appliedTo(sq));
    for (;destination.isValid() && board.at(destination)->color() == 0;
	 destination = (*direction)->appliedTo(destination)){
      if (!capturesOnly)
	moves.push_back(MoveList::value_type(SimpleMove::createInstance(sq, destination)));
    }
    if (destination.isValid() && 
	(board.at(destination)->color() != color()))
      moves.push_back(MoveList::value_type(new CapturingMove(sq, destination)));
  }
};
bool
LongMovingPiece::attacks(const Direction* dir, const Square& location,
			  const Square& target) const
{
  return movesInDirection(dir);
};
