/***************************************************************************
                          Knight.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/Knight.h"
# include "Directions/Direction.h"

using namespace Alice;
Knight::Knight(Color* aColor):
  ShortMovingPiece(aColor, 'N')
{};

Knight::~Knight()
{};

char
Knight::displayLetter() const
{
  return 'N';
};
std::list<const Direction*> Knight::mDirections;

const std::list<const Direction*>&
Knight::directions() const
{
  static bool initialized(false);
  if (! initialized){
    initialized = true;
    mDirections.push_back(&Direction::upUpLeft());
    mDirections.push_back(&Direction::upUpRight());
    mDirections.push_back(&Direction::downDownLeft());
    mDirections.push_back(&Direction::downDownRight());
    mDirections.push_back(&Direction::upLeftLeft());
    mDirections.push_back(&Direction::upRightRight());
    mDirections.push_back(&Direction::downLeftLeft());
    mDirections.push_back(&Direction::downRightRight());
  }
  return mDirections;
};
bool 
Knight::movesInDirection(const Direction* dir) const
{
  return dir->isKnightDirection();
};

bool 
Knight::isKnight() const
{
  return true;
};
Evaluation::Score 
Knight::basicValue() const
{
  return Evaluation::Score(3);
};

bool
Knight::attacks(const Direction* dir, const Square& location,
		       const Square& target) const
{
  return dir->isKnightDirection();
};

int
Knight::centralizationFactor() const
{
  return 6;
};

Bitboard
Knight::getAttacks( const Square& sq ) const
{
  return Bitboard::getKnightAttacks(sq);
};

Piece*
Knight::clone() const
{
  return newKnight( color() );
};
