/***************************************************************************
                          King.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/King.h"
# include "Board.h"
# include "Square.h"
# include "Moves/SimpleMove.h"
# include "Directions/Direction.h"
# include <Moves/CapturingMove.h>
# include <Moves/SimpleMove.h>

using namespace Alice;

King::King(Color* aColor):
  ShortMovingPiece(aColor, 'K')
{};

King::~King()
{};

char
King::displayLetter() const
{
  return 'K';
};

bool
King::isKing() const
{
  return true;
};

std::list<const Direction*> King::mDirections;

const std::list<const Direction*>&
King::directions() const
{
  static bool initialized(false);
  if (! initialized){
    initialized = true;
    mDirections.push_back(& Direction::up());
    mDirections.push_back(& Direction::down());
    mDirections.push_back(& Direction::left());
    mDirections.push_back(& Direction::right());
    mDirections.push_back(& Direction::upLeft());
    mDirections.push_back(& Direction::upRight());
    mDirections.push_back(& Direction::downLeft());
    mDirections.push_back(& Direction::downRight());
  }
  return mDirections;
};

  bool 
King::attacks(const Direction* dir, const Square& location,
		       const Square& target) const
{
  if (dir->isKnightDirection())
    return false;
  return dir->appliedTo(target) == location;
};

int
King::centralizationFactor() const
{
  return -10;
}; 

Bitboard
King::getAttacks( const Square& sq ) const
{
  Bitboard b;
  return Bitboard::getKingAttacks( sq );
};

Piece*
King::clone() const
{
  return newKing( color() );
};
