/***************************************************************************
                          HistoryAlphaBeta.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Algorithms/HistoryAlphaBeta.h"
# include "Game/Game.h"
# include "Moves/SanNotation.h"
# include <Algorithms/HistoryMoveComp.h>
using namespace Alice;

HistoryAlphaBeta::HistoryAlphaBeta(Game& game):
  HashedAlphaBeta(game)
{
  for (std::vector<Square>::const_iterator sq1 
	 = Square::allInstances().begin();
       sq1 != Square::allInstances().end(); ++ sq1)
    for (std::vector<Square>::const_iterator sq2
	   = Square::allInstances().begin();
	 sq2 != Square::allInstances().end(); ++ sq2)
      historyValues[*sq1][*sq2] = 0l;
};
HistoryAlphaBeta::~HistoryAlphaBeta(){};

bool
HistoryAlphaBeta::generateMoves(MoveList& moves)
{
  game().pseudoLegalMoves(moves);
  moves.sort(HistoryMoveComp(game().board(), historyValues));
  return false;
};



void
HistoryAlphaBeta::processCutOff(int depth, Score result,
			       SmartPointer<Move> bestMove)
{
  ttable.storeLowerBound(result, depth, bestMove);
  historyValues[bestMove->source()]
    [bestMove->destination()]+= 1<<depth;
};
void 
HistoryAlphaBeta::failHigh(int depth, Score score,
		    SmartPointer<Move> bestMove)
{
  ttable.storeLowerBound(score, depth, bestMove);
  historyValues[bestMove->source()][bestMove->destination()]+= 1<<depth;
};

void
HistoryAlphaBeta::printInfo()
{
  std::cout<<"history values: "<<std::endl;
  
  MoveList moves;
  generateMoves(moves);
  int i = 1;
  for (MoveList::iterator it = moves.begin(); it != moves.end();
       ++ it, ++i){
    SanNotation san(&**it, game());
    san.printOn(std::cout);
    
    std::cout<<": "<<historyValues[(*it)->source()][(*it)->destination()]<<"; ";
    if (i%5==0)
      std::cout<<std::endl;
  }
  std::cerr<<"done"<<std::endl;
};



void 
HistoryAlphaBeta::setGame(Game& g)
{
  for (std::vector<Square>::const_iterator sq1 
	 = Square::allInstances().begin();
       sq1 != Square::allInstances().end(); ++ sq1)
    for (std::vector<Square>::const_iterator sq2
	   = Square::allInstances().begin();
	 sq2 != Square::allInstances().end(); ++ sq2)
      historyValues[*sq1][*sq2] = 0l;

  HashedAlphaBeta::setGame(g);
};
