# include "Game/GameRecord.h"
# include "Moves/SanNotation.h"
# include <iostream>
using namespace Alice;


GameRecord::GameRecord()
{
};

std::string
GameRecord::getTag(const std::string& name)
{
  return tagSet.getTag( name );
};

void
GameRecord::setTag(const std::string& name,
		   const std::string& value)
{
  tagSet.setTag( name, value );
};

void
GameRecord::addMove(const std::string& move)
{
  moveText.addMove( move );
};

void
GameRecord::addMove(SmartPointer<Move> move)
{
  moveText.addMove( move );
};

int
GameRecord::plyCount() const
{
  return moveText.plyCount();
};

void
GameRecord::read(std::istream& in)
{
  in >> tagSet;
  moveText.read( in );
};

std::string
GameRecord::getForsytheString(int ply)
{
  return moveText.getForsytheString( ply );
};

SmartPointer<Move>
GameRecord::getMove(int ply)
{
  return moveText.getMove( ply );
};

void
GameRecord::printTags() const
{
  tagSet.write( std::cout );
};


void
GameRecord::write( std::ostream& out )
{
  out << tagSet;
  moveText.write( out );
  out << tagSet.getTag("Result") << std::endl;
};

void
GameRecord::insertVariation( std::vector<SmartPointer<Move> >& pv)
{
  moveText.beginVariation();
  for (int i = 0; i < pv.size(); i++)
    moveText.addMove(pv[i]);
  moveText.endVariation();
};
