/***************************************************************************
                          GameObserver.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Game/GameObserver.h"
# include "Moves/Move.h"
# include "Moves/SimpleMove.h"
# include "Moves/CapturingMove.h"
# include "Moves/PromotingMove.h"
# include "Moves/PromotingCapture.h"
# include "Moves/CastlingMove.h"
# include "Moves/DoubleStep.h"
# include "Moves/EnPassantMove.h"
# include "Game/Game.h"
using namespace Alice;

GameObserver::GameObserver():
  observedGame(0)
{}
GameObserver::~GameObserver()
{

    stopObserving();
};

void
GameObserver::startObserving(Game* game)
{
  if (observedGame)
    stopObserving();
  observedGame = game;
  game->addObserver(*this);
};

void
GameObserver::stopObserving()
{
  if (observedGame == 0)
    return;
  observedGame->removeObserver(*this);
  observedGame = 0;
};

void GameObserver::basicDoMove(Move& move)
{};
void GameObserver::doSimpleMove(SimpleMove& move)
{
  basicDoMove(move);
};
void GameObserver::doCapturingMove(CapturingMove& move)
{
  basicDoMove(move);
};
void GameObserver::doPromotingMove(PromotingMove& move)
{
  basicDoMove(move);
};
void GameObserver::doPromotingCapture(PromotingCapture& move)
{
  basicDoMove(move);
};
void GameObserver::doCastlingMove(CastlingMove& move)
{
  basicDoMove(move);
};
void GameObserver::doDoubleStep(DoubleStep& move)
{
  basicDoMove(move);
};
void GameObserver::doEnPassantMove(EnPassantMove& move)
{
  basicDoMove(move);
};
void GameObserver::basicTakeBack(Move& move)
{};
void GameObserver::takeBackSimpleMove(SimpleMove& move)
{
  basicTakeBack(move);
};
void GameObserver::takeBackCapturingMove(CapturingMove& move)
{
  basicTakeBack(move);
};
void GameObserver::takeBackPromotingMove(PromotingMove& move)
{
  basicTakeBack(move);
};
void GameObserver::takeBackPromotingCapture(PromotingCapture& move)
{
  basicTakeBack(move);
};
void GameObserver::takeBackCastlingMove(CastlingMove& move)
{
  basicTakeBack(move);
};

void GameObserver::takeBackDoubleStep(DoubleStep& move)
{
  basicTakeBack(move);
};


void GameObserver::takeBackEnPassantMove(EnPassantMove& move)
{
  basicTakeBack(move);
};

bool
GameObserver::isLateObserver() const
{
	return false;
};
