/***************************************************************************
                          GameBroadcaster.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Game/GameBroadcaster.h"
# include "Moves/Move.h"

# include <list>
# include <algorithm>
# include <cassert>
using namespace Alice;
GameBroadcaster::GameBroadcaster()
{};
GameBroadcaster::~GameBroadcaster()
{
  if (mObservers.size())
    std::cerr<<mObservers.size()<<" observers left"<<std::endl;
  for (std::list<GameObserver*>::iterator it = mObservers.begin();
       it != mObservers.end(); ++ it)
    {
      GameObserver* observer = *it;
      if (observer) // FIXME
	observer->stopObserving();

    }
};
void 
GameBroadcaster::basicDoMove(Move& move)
{
  for (std::list<GameObserver*>::iterator it = mObservers.begin();
       it != mObservers.end(); ++ it)
    move.makeOn(**it);
};
void 
GameBroadcaster::basicTakeBack(Move& move)
{
  for (std::list<GameObserver*>::iterator it = mObservers.begin();
       it != mObservers.end(); ++ it)
    move.takeBackOn(**it);
};
void
GameBroadcaster::doNullMove()
{
  for (std::list<GameObserver*>::iterator it = mObservers.begin();
       it != mObservers.end(); ++ it)
    (*it)->doNullMove();
}
void
GameBroadcaster::takeBackNullMove()
{
  for (std::list<GameObserver*>::iterator it = mObservers.begin();
       it != mObservers.end(); ++ it)
    (*it)->takeBackNullMove();
};
void 
GameBroadcaster::addObserver(GameObserver& observer)
{
  assert(&observer);
  mObservers.push_front(&observer);
  for (std::list<GameObserver*>::iterator it = mObservers.begin();
       it != mObservers.end(); ++it)
    assert(*it);
  //std::cerr<<"added "<<&observer<<std::endl;
};
void 
GameBroadcaster::removeObserver(GameObserver& observer)
{
  std::list<GameObserver*>::iterator it = find(mObservers.begin(), mObservers.end(), &observer);
  assert(it != mObservers.end());
  mObservers.erase(it);
  //std::cerr<<"removed "<<&observer<<std::endl;
};
