# include <ForsytheReader.h>
# include <iostream>
# include <Board.h>
# include <Pieces/Piece.h>
namespace Alice
{
  ForsytheReader::ForsytheReader( Board& b, std::istream& in )
    : board( b ),
      stream( in )
  {};
  ForsytheReader::~ForsytheReader()
  {};
  
  bool 
  ForsytheReader::read()
  {
    board.clear();
    for (int rank = 7; rank >= 0; rank --)
      if (! readRank( rank ) )
	return false;
    return true;
  };
  bool
  ForsytheReader::readRank( int rank )
  {
    for (int file = 0; file < 8; file ++)
      readChar( file, rank );
    return skipSlash( rank );
  };
  void ForsytheReader::readChar(int& file,int rank)
  {
    char c;
    stream>>c;
    if (isdigit(c))
      file += c-'1';
    else
      putPiece( c, file, rank );
  };
  bool
  ForsytheReader::skipSlash( int rank )
  {
    if (!rank)
      return true;
    char c;
    stream >> c;
    return (c == '/');
  };
  void
  ForsytheReader::putPiece( char c, int file, int rank )
  {
    Square sq( file, rank );
    board.put(  Piece::fromForsytheLetter( c ), sq );
  };
    

}; // namespace Alice
