# include <Game/EvaluationFeature.h>
# include <fstream>
# include <numeric>
using namespace Alice;

EvaluationFeature::EvaluationFeature(int numberOfWeights,
				     const char* fileName)
  : weights(numberOfWeights),
    gradient(numberOfWeights),
    difference(numberOfWeights, 0),
    mFileName(fileName),
    couldRead(false)
{
  std::ifstream file(fileName);
  if (!file)
    return;
  couldRead = true;
  for (int i = 0; i < numberOfWeights; i++)
    file >> weights[i];
};

void
EvaluationFeature::addDifference( float factor )
{
  for (int i = 0; i < gradient.size(); i++)
    difference[i] += gradient[i] * factor;
};

void
EvaluationFeature::adjustWeights( )
{
  for (int i = 0; i < weights.size(); i++)
    weights[i] += difference[i];
  std::ofstream file(mFileName);
  if (! file)
    return;
  for (int i = 0; i < weights.size(); i++)
    file << weights[i]<<std::endl;
};

void
EvaluationFeature::print()
{
  for (int i = 0; i < weights.size(); i++)
    std::cout<<weights[i]<<" ";
  std::cout<<std::endl;
};

EvaluationFeature::Score
EvaluationFeature::squaredNorm() const
{
  return std::inner_product(gradient.begin(), gradient.end(),
			    gradient.begin(), .0f);
};


Evaluation::Score
EvaluationFeature::score(Game* g)
{
  computeGradient( g );
  return std::inner_product(weights.begin(), weights.end(),
			    gradient.begin(), Evaluation::Score(0));
};

void
EvaluationFeature::computeGradient( Game* g )
{

};

void
EvaluationFeature::clearGradient()
{

  for (int i = 0; i < gradient.size(); i++)
    gradient[i] = 0;
};
