/***************************************************************************
                          EnPassantSentry.cpp  -  description
                             -------------------
    begin                : Thu Aug 23 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "Game/EnPassantSentry.h"
# include "Moves/DoubleStep.h"
# include <sstream>
using namespace Alice;

EnPassantSentry::EnPassantSentry(){
	epSquares.push(Square(8,0));
}
EnPassantSentry::~EnPassantSentry(){
}

Square
EnPassantSentry::square() const
{
	return epSquares.top();
};

void
EnPassantSentry::basicDoMove(Move&)
{
	//std::cerr<<"--------------"<<std::endl;
	epSquares.push(Square::invalid());
};

void EnPassantSentry::basicTakeBack( Move&)
{
	epSquares.pop();
};

void EnPassantSentry::doDoubleStep(DoubleStep& move)
{
	//std::cerr<<"########"<<std::endl;
	epSquares.push(move.passedSquare());
};

std::string
EnPassantSentry::getEPDString() const
{
  Square epSquare = square();
  if (! epSquare.isValid())
    return "-";
  std::ostringstream output;
  output << epSquare;
  return output.str();
};
