/***************************************************************************
                          EnPassantMove.cpp  -  description
                             -------------------
    begin                : Sat Aug 25 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "Moves/EnPassantMove.h"
# include "Board.h"
# include "Game/Game.h"
using namespace Alice;

EnPassantMove::EnPassantMove(const Square& from,
			     const Square& to,
			     const Square& capturing)
  : CapturingMove(from, to),
    mCapturedSquare(capturing)															
{
};
EnPassantMove::~EnPassantMove(){
};

void
EnPassantMove::makeOn(Board& b)
{
  mCapture = b.at(capturedSquare());
  b.put(b.at(source()), destination());
  b.clear(source());
  b.clear(capturedSquare());
};
void
EnPassantMove::takeBackOn(Board& b)
{
  b.put(b.at(destination()), source());
  b.put(capture(), capturedSquare());
  b.clear(destination());
};

void
EnPassantMove::makeOn(GameObserver& g)
{
	g.doEnPassantMove(*this);
};

void
EnPassantMove::takeBackOn(GameObserver& g)
{
	g.takeBackEnPassantMove(*this);
};
/** adds suffix "e.p." */
void EnPassantMove::printOn(std::ostream& out) const{
	CapturingMove::printOn(out);
	out<<" e.p.";
}
/** check if there is an e.p. square */
bool EnPassantMove::isLegal(const Game& game) const{

	if (!Move::isLegal(game))
		return false;
		return true;
	return (capturedSquare() == game.epSquare());
}
EnPassantMove::Link*
EnPassantMove::enPassantPool = 0;
void*
EnPassantMove::operator new(size_t s)
{
	
	if (s == sizeof(EnPassantMove) && enPassantPool != 0) {
		EnPassantMove* p = reinterpret_cast<EnPassantMove*>(enPassantPool);
		enPassantPool = enPassantPool->next;
		reuse ++;
		return p;
	}
	created ++;
	return malloc(sizeof(EnPassantMove));
};

void
EnPassantMove::operator delete (void* p, size_t s)
{
	Link* l = reinterpret_cast<Link*>(p);
	l->next = enPassantPool;
	enPassantPool = l;
};
