/***************************************************************************
                          DoubleStep.cpp  -  description
                             -------------------
    begin                : Thu Aug 23 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "Moves/DoubleStep.h"
# include "Game/GameObserver.h"
using namespace Alice;

DoubleStep::DoubleStep(const Square& from, const Square& to,
											 const Square& via):
	SimpleMove(from, to),
	mVia(via)
{
};
DoubleStep::~DoubleStep(){
}

void
DoubleStep::makeOn(GameObserver& b)
{
	b.doDoubleStep(*this);
};



void
DoubleStep::operator delete (void* p, size_t s)
{
	Link* l = reinterpret_cast<Link*>(p);
	l->next = doublePool;
	doublePool = l;
};

int DoubleStep::createdNew = 0;
int DoubleStep::reuse = 0;
void
DoubleStep::printInfo()
{
	std::cout<<"DoubleStep: ";
	std::cout<<createdNew<<" created new, ";
	std::cout<<reuse<<" reused, ";
	int i = 0;
	Link* l = doublePool;
	while(l) {
		l = l->next;
		i++;
	}
	std::cout<<"pool size: "<<i<<std::endl;
};
DoubleStep*
DoubleStep::createInstance(const Square& from, const Square& to, const Square& via)
{
	/*if (doublePool != 0) {
		DoubleStep* p = reinterpret_cast<DoubleStep*>(doublePool);
		doublePool = doublePool->next;
		reuse ++;
		return new(p) DoubleStep(from, to, via);
	}
	createdNew ++;
	return new DoubleStep(from, to, via);*/
	return new DoubleStep(from, to , via);
};

void*
DoubleStep::operator new(size_t s)
{
	if (doublePool != 0) {
		DoubleStep* p = reinterpret_cast<DoubleStep*>(doublePool);
		doublePool = doublePool->next;
		reuse ++;
		return p;
	}
	createdNew ++;
	return malloc(sizeof(DoubleStep));
};
