/***************************************************************************
                          CastlingMove.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Moves/CastlingMove.h"
# include "Board.h"
# include "Pieces/Piece.h"
# include "Game/GameObserver.h"
# include "Moves/SanNotation.h"
using namespace Alice;
CastlingMove::CastlingMove(const Square& from, const Square& to,
			   const Square& rookFrom, const Square& rookTo):
  Move(from, to),
  rookSource(rookFrom),
  rookDestination(rookTo)
{};

CastlingMove::~CastlingMove()
{};

void
CastlingMove::makeOn(Board& b)
{
  b.put(b.at(source()), destination());
  Square sq(source());// optimizer bug?
  b.clear(sq);
  if (!(b.at(rookSource)->isRook()))
    {
      std::cerr<<"error making castling"<<std::endl;
      b.displayOn(std::cerr);
      exit(1);
    }
  b.put(b.at(rookSource), rookDestination);
  b.clear(rookSource);
  
};
void
CastlingMove::takeBackOn(Board& b)
{
  if (!(b.at(rookDestination)->isRook()))
    {
      std::cerr<<"error taking back castling"<<std::endl;
      source().printOn(std::cerr);
      destination().printOn(std::cerr);
      //      std::cerr<<source<<destination<<std::endl;
      b.displayOn(std::cerr);
      exit(1);
    }
  b.put(b.at(destination()), source());
  Square sq(destination());
  b.clear(sq);
  b.put(b.at(rookDestination), rookSource);
  b.clear(rookDestination);
};

void
CastlingMove::makeOn(GameObserver& b)
{
  b.doCastlingMove(*this);
};
void
CastlingMove::takeBackOn(GameObserver& b)
{
  b.takeBackCastlingMove(*this);
};

void
CastlingMove::printOn(std::ostream& out) const
{
	out<<"O-O";
	if (destination().file() == 2)
		out<<"-O";
};
bool CastlingMove::isLegal(const Game& game) const{return Move::isLegal(game);};
void
CastlingMove::modifySan(SanNotation& san) const
{
	san.setCastling(destination().file() == 2);
};
