/***************************************************************************
                          Bishop.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Pieces/Bishop.h"

# include "Directions/Direction.h"
# include <Board.h>
# include <Moves/SimpleMove.h>
# include <Moves/CapturingMove.h>
using namespace Alice;

Bishop::Bishop(Color* aColor):
  LongMovingPiece(aColor, 'B')
{};

Bishop::~Bishop()
{};

char
Bishop::displayLetter() const
{
  return 'B';
};
std::list<const Direction*>
Bishop::mDirections;
const std::list<const Direction*>&
Bishop::directions() const
{
  static bool initialized(false);
  if (! initialized){
    initialized = true;
    mDirections.push_back(& Direction::upLeft());
    mDirections.push_back(& Direction::upRight());
    mDirections.push_back(& Direction::downLeft());
    mDirections.push_back(& Direction::downRight());
  }
  return mDirections;
};

bool
Bishop::movesInDirection(const Direction* dir) const
{
  return dir->isDiagonal();
};
Evaluation::Score 
Bishop::basicValue() const
{
  return Evaluation::Score(3);
};

bool
Bishop::isBishop() const
{
  return true;
};

int
Bishop::centralizationFactor() const
{
  return 6;
};
Bitboard
Bishop::getAttacks( const Board& b, const Square& sq ) const
{
  Bitboard result = b.getAllPiecesRotated45().getDownDiagonalAttacks(sq);
  result |= b.getAllPiecesRotated135().getUpDiagonalAttacks(sq);
  return result;
};

Piece*
Bishop::clone() const
{
  return newBishop(color() );
};
